<?php
/**
 * @since: 1.0.0
 * @author: KP
 * @create: 16-Nov-17
 */
?>
<div class="lqd-export-demos">
    <h3><?php echo esc_html__('Export', LQD_TEXT_DOMAIN) ?></h3>
    <form method="post" class="lqd-export-contents">
        <div class="lqd-export-name">
            <input required='' type="text" id="lqd-ie-id" name="lqd-ie-id" placeholder='<?php echo esc_html__('Name', LQD_TEXT_DOMAIN) ?>'>
        </div>
        <div class="lqd-export-link">
            <input required='' type="text" id="lqd-ie-link" name="lqd-ie-link" placeholder='<?php echo esc_html__('Demo Link', LQD_TEXT_DOMAIN) ?>'>
        </div>
        <div class="lqd-export-options">
            <h4><?php echo esc_html__('Select data:', LQD_TEXT_DOMAIN) ?></h4>
            <div class="lqd-export-list-opt">
                <div class="lqd-checkbox-wrap">
                    <div class="lqd-checkbox">
                        <input id="lqd-ie-data-media" name="lqd-ie-data-type[]" type="checkbox" value="attachment" checked="checked">
                        <span></span>
                        <label for="lqd-ie-data-media"><?php esc_html_e('Media', LQD_TEXT_DOMAIN); ?></label>
                    </div>
                </div>
                <div class="lqd-checkbox-wrap">
                    <div class="lqd-checkbox">
                        <input id="lqd-ie-data-widget" name="lqd-ie-data-type[]" type="checkbox" value="widgets"
                               checked="checked">
                        <span></span>
                        <label for="lqd-ie-data-widget"><?php esc_html_e('Widgets', LQD_TEXT_DOMAIN); ?></label>
                    </div>
                </div>
                <div class="lqd-checkbox-wrap">
                    <div class="lqd-checkbox">
                        <input id="lqd-ie-data-setting" name="lqd-ie-data-type[]" type="checkbox" value="options"
                               checked="checked">
                        <span></span>
                        <label for="lqd-ie-data-setting"><?php esc_html_e('WP Settings', LQD_TEXT_DOMAIN); ?></label>
                    </div>
                </div>
                <?php if (class_exists('ReduxFramework')): ?>
                    <div class="lqd-checkbox-wrap">
                        <div class="lqd-checkbox">
                            <input id="lqd-ie-data-option" name="lqd-ie-data-type[]" type="checkbox" value="settings"
                                   checked="checked">
                            <span></span>
                            <label for="lqd-ie-data-option"><?php esc_html_e('Theme Options', LQD_TEXT_DOMAIN); ?></label>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (function_exists('cptui_get_post_type_data')): ?>
                    <div class="lqd-checkbox-wrap">
                        <div class="lqd-checkbox">
                            <input id="lqd-ie-data-posttype" name="lqd-ie-data-type[]" type="checkbox" value="ctp_ui"
                                   checked="checked">
                            <span></span>
                            <label for="lqd-ie-data-posttype"><?php esc_html_e('Post Type', LQD_TEXT_DOMAIN); ?></label>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="lqd-checkbox-wrap">
                    <div class="lqd-checkbox">
                        <input id="lqd-ie-data-content" name="lqd-ie-data-type[]" type="checkbox" value="content"
                               checked="checked">
                        <span></span>
                        <label for="lqd-ie-data-content"><?php esc_html_e('Content', LQD_TEXT_DOMAIN); ?></label>
                    </div>
                </div>
                <?php if (class_exists('RevSlider')): ?>
                    <div class="lqd-checkbox-wrap">
                        <div class="lqd-checkbox">
                            <input id="lqd-ie-data-rev" name="lqd-ie-data-type[]" type="checkbox" value="revslider"
                                   checked="checked">
                            <span></span>
                            <label for="lqd-ie-data-rev"><?php esc_html_e('Slider Revolution', LQD_TEXT_DOMAIN); ?></label>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="lqd-export-btn">
            <input type="hidden" name="action" value="lqd-export">
            <button type="submit"
                    class="button button-primary create-demo"><?php esc_html_e('Create Demo', LQD_TEXT_DOMAIN); ?></button>
            <button type="submit" class="button button-primary download-demo" name="lqd-ie-download"
                    value="lqd"><?php esc_html_e('Download All Demos', LQD_TEXT_DOMAIN); ?></button>
        </div>
    </form>
</div>
